"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteAddress = exports.getAddressById = exports.getAddresses = exports.addAddress = void 0;
const asyncHandler_1 = __importDefault(require("../utils/asyncHandler"));
const apiError_1 = __importDefault(require("../utils/apiError"));
const apiResponse_1 = __importDefault(require("../utils/apiResponse"));
const db_1 = __importDefault(require("../DB/db"));
// --- Add New Address ---
exports.addAddress = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const userId = (_a = req.params) === null || _a === void 0 ? void 0 : _a.id;
    const { street, city, state, zipCode, country, phone, type, isDefault, addressId, fullName, email } = req.body;
    // If setting as default, unset previous default
    if (isDefault) {
        yield db_1.default.address.updateMany({
            where: { userId, isDefault: true },
            data: { isDefault: false },
        });
    }
    const address = yield db_1.default.address.upsert({
        where: {
            id: addressId,
        },
        update: {
            email,
            fullName,
            street,
            city,
            state,
            zipCode,
            country,
            phone,
            type: type || 'HOME',
            isDefault: isDefault || false,
        },
        create: {
            userId: userId,
            email,
            fullName,
            street,
            city,
            state,
            zipCode,
            country,
            phone,
            type: type || 'HOME',
            isDefault: isDefault || false,
        },
    });
    return res.status(201).json(new apiResponse_1.default(true, 201, 'Address added', address));
}));
// --- Get All Addresses ---
exports.getAddresses = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const userId = (_a = req.params) === null || _a === void 0 ? void 0 : _a.id;
    const addresses = yield db_1.default.address.findMany({
        where: { userId },
        orderBy: { isDefault: 'desc' }, // Default address comes first
    });
    return res.status(200).json(new apiResponse_1.default(true, 200, 'Addresses fetched', addresses));
}));
// --- Get Address  By Id ---
exports.getAddressById = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { id } = req.params;
    // Ensure user owns this address
    const address = yield db_1.default.address.findFirst({
        where: { userId: id, isDefault: true },
    });
    return res.status(200).json(new apiResponse_1.default(true, 200, 'Address Fetch Successfully', address));
}));
// --- Delete Address ---
exports.deleteAddress = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const { id } = req.params;
    const userId = (_a = req.user) === null || _a === void 0 ? void 0 : _a.id;
    // Ensure user owns this address
    const address = yield db_1.default.address.findFirst({
        where: { id, userId },
    });
    if (!address)
        throw new apiError_1.default(false, 404, 'Address not found');
    yield db_1.default.address.delete({ where: { id } });
    return res.status(200).json(new apiResponse_1.default(true, 200, 'Address deleted'));
}));
