"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteBanner = exports.updateBanner = exports.createBanner = exports.getBanners = void 0;
const client_1 = require("@prisma/client");
const apiError_1 = __importDefault(require("../../utils/apiError"));
const r2_1 = require("../../utils/r2");
const prisma = new client_1.PrismaClient();
// GET /api/admin/banners
const getBanners = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const banners = yield prisma.banner.findMany({
            orderBy: { order: 'asc' }, // Sort by display order
        });
        res.json(banners);
    }
    catch (error) {
        console.error("Get Banners Error:", error);
        res.status(500).json({ error: "Failed to fetch banners" });
    }
});
exports.getBanners = getBanners;
// POST /api/admin/banners
const createBanner = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { title, link, buttonText, active, order } = req.body;
        if (!title || !link) {
            return res.status(400).json({ error: "Title, Image URL, and Link are required" });
        }
        const imageFile = req.file;
        if (!imageFile.path) {
            throw new apiError_1.default(false, 400, "Images is required");
        }
        const uploadtoR2 = yield (0, r2_1.uploadFileToR2)(imageFile);
        const newBanner = yield prisma.banner.create({
            data: {
                title,
                image: uploadtoR2.url,
                link,
                buttonText: buttonText || "Shop Now", // Default if empty
                active: active === "true",
                order: order ? parseInt(order) : 0,
            },
        });
        res.status(201).json(newBanner);
    }
    catch (error) {
        console.error("Create Banner Error:", error);
        res.status(500).json({ error: "Failed to create banner" });
    }
});
exports.createBanner = createBanner;
// PUT /api/admin/banners/:id
const updateBanner = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { id } = req.params;
        const { title, image, link, buttonText, active, order } = req.body;
        const updatedBanner = yield prisma.banner.update({
            where: { id },
            data: {
                title,
                image,
                link,
                buttonText,
                active,
                order: order ? parseInt(order) : undefined,
            },
        });
        res.json(updatedBanner);
    }
    catch (error) {
        console.error("Update Banner Error:", error);
        res.status(500).json({ error: "Failed to update banner" });
    }
});
exports.updateBanner = updateBanner;
// DELETE /api/admin/banners/:id
const deleteBanner = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { id } = req.params;
        yield prisma.banner.delete({ where: { id } });
        res.json({ message: "Banner deleted successfully" });
    }
    catch (error) {
        console.error("Delete Banner Error:", error);
        res.status(500).json({ error: "Failed to delete banner" });
    }
});
exports.deleteBanner = deleteBanner;
