"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteBanner = exports.createBanner = exports.getBanners = void 0;
const client_1 = require("@prisma/client");
const r2_1 = require("../../utils/r2");
const apiError_1 = __importDefault(require("../../utils/apiError"));
const prisma = new client_1.PrismaClient();
// GET: Fetch all banners (Public or Admin)
const getBanners = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const banners = yield prisma.featuredBanner.findMany({
            orderBy: { createdAt: 'desc' },
        });
        res.json(banners);
    }
    catch (error) {
        res.status(500).json({ error: 'Failed to fetch banners' });
    }
});
exports.getBanners = getBanners;
// POST: Create a new banner (Admin Only)
const createBanner = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { title, description, cta, link } = req.body;
        // 1. Strict Check: Max 2 Banners
        const count = yield prisma.featuredBanner.count();
        if (count >= 2) {
            return res.status(400).json({
                error: 'Limit reached. You can only have 2 active banners. Delete one to add a new one.',
            });
        }
        const imageFile = req.file;
        if (!imageFile) {
            throw new apiError_1.default(false, 400, 'Image is required');
        }
        const uploadImgToR2 = yield (0, r2_1.uploadFileToR2)(imageFile);
        if (!(uploadImgToR2 === null || uploadImgToR2 === void 0 ? void 0 : uploadImgToR2.url)) {
            throw new apiError_1.default(false, 400, 'Image is fail to upload to R2');
        }
        // 2. Create Banner
        const banner = yield prisma.featuredBanner.create({
            data: {
                image: uploadImgToR2.url,
                title,
                description,
                cta,
                link,
            },
        });
        res.status(201).json(banner);
    }
    catch (error) {
        console.error(error);
        res.status(500).json({ error: 'Failed to create banner' });
    }
});
exports.createBanner = createBanner;
// DELETE: Remove a banner (Admin Only)
const deleteBanner = (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const { id } = req.params;
        yield prisma.featuredBanner.delete({ where: { id } });
        res.json({ message: 'Banner deleted successfully' });
    }
    catch (error) {
        res.status(500).json({ error: 'Failed to delete banner' });
    }
});
exports.deleteBanner = deleteBanner;
