"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCategory = exports.getCategoryTree = void 0;
const asyncHandler_1 = __importDefault(require("../utils/asyncHandler"));
const apiResponse_1 = __importDefault(require("../utils/apiResponse"));
const db_1 = __importDefault(require("../DB/db"));
const slugify_1 = __importDefault(require("slugify"));
// --- Get Category Tree (Public) ---
exports.getCategoryTree = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const categories = yield db_1.default.category.findMany({
        where: { parentId: null },
        include: {
            children: {
                include: {
                    children: true, // supports deep nesting
                },
            },
        },
        orderBy: { name: "asc" },
    });
    res.json(new apiResponse_1.default(true, 200, "Category tree", categories));
}));
// --- Create Category (Admin) ---
exports.createCategory = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { name, parentId, description, image } = req.body;
    const slug = (0, slugify_1.default)(name, { lower: true });
    const category = yield db_1.default.category.create({
        data: {
            name,
            slug,
            parentId: parentId || null, // Optional parent
            description,
            image
        },
    });
    return res.status(201).json(new apiResponse_1.default(true, 201, "Category created", category));
}));
