"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProductReviews = exports.addReview = void 0;
const asyncHandler_1 = __importDefault(require("../utils/asyncHandler"));
const apiError_1 = __importDefault(require("../utils/apiError"));
const apiResponse_1 = __importDefault(require("../utils/apiResponse"));
const db_1 = __importDefault(require("../DB/db"));
// --- Add Review ---
exports.addReview = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const userId = (_a = req.user) === null || _a === void 0 ? void 0 : _a.id;
    const { productId, rating, comment } = req.body;
    // 1. Check if user bought the product (Optional logic for Verified Purchase)
    /*
    const hasPurchased = await prisma.order.findFirst({
      where: {
        userId,
        status: "DELIVERED",
        items: { some: { productId } } // Check snapshots or relation
      }
    });
    if (!hasPurchased) throw new ApiError(false, 403, "You can only review purchased items");
    */
    // 2. Check for existing review
    const existingReview = yield db_1.default.review.findFirst({
        where: { userId, productId },
    });
    if (existingReview) {
        throw new apiError_1.default(false, 400, "You have already reviewed this product");
    }
    // 3. Create Review
    const review = yield db_1.default.review.create({
        data: {
            userId: userId,
            productId,
            rating: Number(rating),
            comment,
        },
    });
    return res.status(201).json(new apiResponse_1.default(true, 201, "Review added", review));
}));
// --- Get Product Reviews ---
exports.getProductReviews = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { productId } = req.params;
    const reviews = yield db_1.default.review.findMany({
        where: { productId },
        include: {
            user: {
                select: { name: true, image: true }, // Only show name/avatar
            },
        },
        orderBy: { createdAt: "desc" },
    });
    return res.status(200).json(new apiResponse_1.default(true, 200, "Reviews fetched", reviews));
}));
