"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteWishlist = exports.getMyWishlist = exports.toggleWishlist = void 0;
const asyncHandler_1 = __importDefault(require("../utils/asyncHandler"));
const apiError_1 = __importDefault(require("../utils/apiError"));
const apiResponse_1 = __importDefault(require("../utils/apiResponse"));
const db_1 = __importDefault(require("../DB/db"));
// --- Toggle Wishlist Item (Add/Remove) ---
exports.toggleWishlist = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const userId = (_a = req.params) === null || _a === void 0 ? void 0 : _a.id;
    const { productId } = req.body;
    // 1. Ensure Wishlist Exists
    let wishlist = yield db_1.default.wishlist.findUnique({ where: { userId } });
    if (!wishlist) {
        wishlist = yield db_1.default.wishlist.create({ data: { userId: userId } });
    }
    // 2. Check if item exists in wishlist
    const existingItem = yield db_1.default.wishlistItem.findUnique({
        where: {
            wishlistId_productId: {
                wishlistId: wishlist.id,
                productId,
            },
        },
    });
    if (existingItem) {
        // Remove it
        yield db_1.default.wishlistItem.delete({ where: { id: existingItem.id } });
        return res
            .status(200)
            .json(new apiResponse_1.default(true, 200, 'Removed from wishlist', { added: false }));
    }
    else {
        // Add it
        yield db_1.default.wishlistItem.create({
            data: {
                wishlistId: wishlist.id,
                productId,
            },
        });
        return res.status(200).json(new apiResponse_1.default(true, 200, 'Added to wishlist', { added: true }));
    }
}));
// --- Get My Wishlist ---
exports.getMyWishlist = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const userId = (_a = req.params) === null || _a === void 0 ? void 0 : _a.id;
    const wishlist = yield db_1.default.wishlist.findUnique({
        where: { userId },
        include: {
            items: {
                include: {
                    product: {
                        include: {
                            category: {
                                select: { name: true, slug: true } // Fetch category for UI tags
                            },
                            variants: true, // Fetch variants for stock logic
                        },
                    },
                },
            },
        },
    });
    // Handle case where wishlist doesn't exist yet
    if (!wishlist) {
        return res.status(200).json(new apiResponse_1.default(true, 200, "Wishlist fetched", { id: null, items: [] }));
    }
    // Return BOTH the Wishlist ID and the Items array
    return res.status(200).json(new apiResponse_1.default(true, 200, "Wishlist fetched", wishlist));
}));
// delete wishlist
exports.deleteWishlist = (0, asyncHandler_1.default)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { id } = req.params;
    if (!id) {
        throw new apiError_1.default(false, 400, 'Id id required');
    }
    const deleteList = yield db_1.default.wishlistItem.delete({
        where: {
            id: id,
        },
    });
    res.status(200)
        .json(new apiResponse_1.default(true, 200, "wishlist removed successfully"));
}));
