"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const featured_category_controller_1 = require("../../controllers/admin/featured-category.controller");
const multerMiddleware_1 = __importDefault(require("../../middlewares/multerMiddleware"));
const router = (0, express_1.Router)();
// Bento Grid Routes
router.get('/', featured_category_controller_1.getBentoItems);
router.post('/', multerMiddleware_1.default.single("image"), featured_category_controller_1.createBentoItem);
router.put('/:id', featured_category_controller_1.updateBentoItem);
router.delete('/:id', featured_category_controller_1.deleteBentoItem);
exports.default = router;
