"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const multerMiddleware_1 = __importDefault(require("../../middlewares/multerMiddleware"));
const featuredBanner_controller_1 = require("../../controllers/admin/featuredBanner.controller");
const router = (0, express_1.Router)();
// --- Products ---
router.get('/', featuredBanner_controller_1.getBanners);
router.post('/', multerMiddleware_1.default.single('image'), featuredBanner_controller_1.createBanner);
router.delete('/:id', featuredBanner_controller_1.deleteBanner);
exports.default = router;
