"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const order_controller_1 = require("../../controllers/admin/order.controller");
const router = (0, express_1.Router)();
// Order List
router.get('/', order_controller_1.getOrders);
// Order Details
router.get('/:id', order_controller_1.getOrderDetails);
// Updates
router.put('/:id/status', order_controller_1.updateOrderStatus);
router.put('/:id/payment', order_controller_1.updatePaymentStatus);
exports.default = router;
