"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const cart_controller_js_1 = require("../controllers/cart.controller.js");
const cart_controller_js_2 = require("../controllers/cart.controller.js");
;
const router = (0, express_1.Router)();
// router.use(jwtVerify);
router.get('/:id', cart_controller_js_1.getUserCartItem);
router.post('/addToCart', cart_controller_js_2.addToCart);
router.put("/increment/:cartItemId", cart_controller_js_1.incrementCartItem);
router.put("/decrement/:cartItemId", cart_controller_js_1.decrementCartItem);
router.get('/cartitemCount/:id', cart_controller_js_1.getCartItemCount);
exports.default = router;
