"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const checkout_controller_1 = require("../controllers/checkout.controller");
const router = express_1.default.Router();
router.post("/create-stripe-session", checkout_controller_1.createStripeSession);
router.post("/create-order", checkout_controller_1.createOrder);
router.post("/cod/:userId", checkout_controller_1.createCodOrder);
router.post("/webhook", express_1.default.raw({ type: "application/json" }), checkout_controller_1.stripeWebhook);
router.get("/user/:userId/orders", checkout_controller_1.getUserOrders);
exports.default = router;
