"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const cms_controller_1 = require("../controllers/cms.controller");
const multerMiddleware_1 = __importDefault(require("../middlewares/multerMiddleware"));
const router = (0, express_1.Router)();
// Public Route
router.get("/heritage-story", cms_controller_1.getHeritageStory);
// Admin Route
router.put("/heritage-story", multerMiddleware_1.default.single("image"), cms_controller_1.updateHeritageStory);
exports.default = router;
