"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const product_controller_js_1 = require("../controllers/product.controller.js");
const router = express_1.default.Router();
router.get('/', product_controller_js_1.getProducts);
router.get('/:id', product_controller_js_1.getProductById);
router.get("/favorites/monthly", product_controller_js_1.getMonthlyFavorites);
router.get("/discount/new", product_controller_js_1.getDiscountedProducts);
router.get("/features/new", product_controller_js_1.getFeaturesProducts);
exports.default = router;
