"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// routes/provinceRoutes.ts
const express_1 = require("express");
const province_controller_js_1 = require("../controllers/province.controller.js");
const authMiddleware_js_1 = require("../middlewares/authMiddleware.js");
const router = (0, express_1.Router)();
// Only admin/country_manager allowed (example)
router.get('/', authMiddleware_js_1.jwtVerify, province_controller_js_1.getAllProvinces);
router.post('/', authMiddleware_js_1.jwtVerify, (0, authMiddleware_js_1.authorizeRoles)('admin', 'country_manager', 'hr'), province_controller_js_1.createProvince);
router.put('/:id', authMiddleware_js_1.jwtVerify, (0, authMiddleware_js_1.authorizeRoles)('admin', 'country_manager', 'hr'), province_controller_js_1.updateProvince);
router.delete('/:id', authMiddleware_js_1.jwtVerify, (0, authMiddleware_js_1.authorizeRoles)('admin', 'country_manager', 'hr'), province_controller_js_1.deleteProvince);
exports.default = router;
