"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const multerMiddleware_1 = __importDefault(require("../middlewares/multerMiddleware"));
const r2_1 = require("../utils/r2");
const router = (0, express_1.Router)();
router.post('/upload', multerMiddleware_1.default.single("avatar"), (req, res) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        console.log('++++++++++++', req.file);
        // 1. Check if file exists before passing it to R2
        if (!req.file) {
            return res.status(400).json({ error: "No avatar file provided" });
        }
        // 2. Upload
        const result = yield (0, r2_1.uploadFileToR2)(req.file);
        console.log("+++++++++++++++++++r2Url", result.url);
        // 3. Return response
        return res.json({
            url: result.url
        });
    }
    catch (error) {
        console.error("Upload route error:", error);
        return res.status(500).json({ error: "Internal Server Error" });
    }
}));
exports.default = router;
