import { Router } from 'express';
import { getBanners,createBanner,updateBanner,deleteBanner } from '../../controllers/admin/banner.controller';
import upload from '../../middlewares/multerMiddleware';

const router = Router();

// Banner Routes
router.get('/', getBanners);
router.post('/',upload.single("imageFile"), createBanner);
router.put('/:id',  updateBanner);
router.delete('/:id',  deleteBanner);

export default router;