import { Router } from 'express';
import {
  getOrders,
  getOrderDetails,
  updateOrderStatus,
  updatePaymentStatus,
} from '../../controllers/admin/order.controller';

const router = Router();

// Order List
router.get('/', getOrders);

// Order Details
router.get('/:id', getOrderDetails);

// Updates
router.put('/:id/status', updateOrderStatus);
router.put('/:id/payment', updatePaymentStatus);

export default router;
