import { Router } from 'express';
import { getProducts,getProductDetails,createProduct,updateProduct, deleteProduct } from '../../controllers/admin/product.controller';
import upload from '../../middlewares/multerMiddleware';


const router = Router();

// --- Products ---
router.get('',  getProducts);
router.get('/:id', getProductDetails);
router.post(
  "/",
  upload.array("images", 5), 
  createProduct
);
router.put('/:id', updateProduct);
router.delete('/:id', deleteProduct);



export default router;