import express from 'express';
import {
  registerUserControllers,
  loginUserControllers,
  verifyUserControllers,
  logoutUserControllers,
} from '../controllers/auth.controller';
import { jwtVerify } from '../middlewares/authMiddleware';
 

const router = express.Router();

router.post('/register', registerUserControllers);

router.post('/login', loginUserControllers);

router.get('/verify', jwtVerify, verifyUserControllers);

router.post('/logout',jwtVerify, logoutUserControllers);

export default router;
