import express from "express";
import { createOrder, stripeWebhook, getUserOrders, createCodOrder, createStripeSession } from "../controllers/checkout.controller";

const router = express.Router();

router.post("/create-stripe-session", createStripeSession);
router.post("/create-order", createOrder);
router.post("/cod/:userId", createCodOrder);
router.post("/webhook", express.raw({ type: "application/json" }), stripeWebhook);
router.get("/user/:userId/orders", getUserOrders);

export default router;
